<?php
	$hudson_edge_options = hudson_edge_return_global_options();
    $hudson_edge_id = hudson_edge_get_page_id();
    $hudson_edge_template_name = get_page_template_slug( $hudson_edge_id );
    $hudson_edge_sidebar = hudson_edge_get_sidebar_layout();
	$hudson_edge_blog_query = hudson_edge_get_blog_query_posts();

	$hudson_edge_blog_style = "1";
	if(isset($hudson_edge_options['blog_style'])){
		$hudson_edge_blog_style = $hudson_edge_options['blog_style'];
	}

	$hudson_edge_filter = "no";
	if($hudson_edge_template_name == "blog-masonry-gallery-full-width.php" || $hudson_edge_template_name == "blog-masonry-gallery.php" || $hudson_edge_blog_style==14 || $hudson_edge_blog_style== 15) {
		if(isset($hudson_edge_options['blog_masonry_gallery_filter'])){
			$hudson_edge_filter = $hudson_edge_options['blog_masonry_gallery_filter'];
		}
	}
	else {
		if(isset($hudson_edge_options['blog_masonry_filter'])){
			$hudson_edge_filter = $hudson_edge_options['blog_masonry_filter'];
		}
	}

    if ( get_query_var('paged') ) { $hudson_edge_paged = get_query_var('paged'); }
    elseif ( get_query_var('page') ) { $hudson_edge_paged = get_query_var('page'); }
    else { $hudson_edge_paged = 1; }
    
    if(isset($hudson_edge_options['blog_page_range']) && $hudson_edge_options['blog_page_range'] != ""){
        $hudson_edge_blog_page_range = esc_attr($hudson_edge_options['blog_page_range']);
    } else{
        $hudson_edge_blog_page_range = $hudson_edge_blog_query->max_num_pages;
    }
	
	
	$hudson_edge_blog_masonry_type = "blog_masonry_standard";
	if(isset($hudson_edge_options['blog_masonry_choose_type'])){
		$hudson_edge_blog_masonry_type = $hudson_edge_options['blog_masonry_choose_type'];
	} 

	$hudson_edge_blog_list = "";
	if($hudson_edge_template_name != "") {
		if($hudson_edge_template_name == "blog-masonry.php"){
			if($hudson_edge_blog_masonry_type == "blog_masonry_standard"){
				$hudson_edge_blog_list = "blog_masonry";
				$hudson_edge_blog_list_class = "masonry";
			}
		}elseif($hudson_edge_template_name == "blog-masonry-full-width.php"){
			if($hudson_edge_blog_masonry_type == "blog_masonry_standard"){
				$hudson_edge_blog_list = "blog_masonry";
				$hudson_edge_blog_list_class = "masonry_full_width";
			}
		}elseif($hudson_edge_template_name == "blog-standard-whole-post.php"){
			$hudson_edge_blog_list = "blog_standard_whole_post";
			$hudson_edge_blog_list_class = "blog_standard_type";
		}elseif($hudson_edge_template_name == "blog-masonry-gallery.php"){
            $hudson_edge_blog_list = "blog_masonry_gallery";
            $hudson_edge_blog_list_class = "blog_masonry_gallery";// Check
        }elseif($hudson_edge_template_name == "blog-masonry-gallery-full-width.php"){
            $hudson_edge_blog_list = "blog_masonry_gallery";
            $hudson_edge_blog_list_class = "blog_masonry_gallery masonry_gallery_full_width";// Check
        }else{
			$hudson_edge_blog_list = "blog_standard";
			$hudson_edge_blog_list_class = "blog_standard_type";
		}
	} else{
		if($hudson_edge_blog_style=="1"){
			$hudson_edge_blog_list = "blog_standard";
			$hudson_edge_blog_list_class = "blog_standard_type";
		}elseif($hudson_edge_blog_style=="3"){
			if($hudson_edge_blog_masonry_type == "blog_masonry_standard"){
				$hudson_edge_blog_list = "blog_masonry";
				$hudson_edge_blog_list_class = "masonry";
			}
        }elseif($hudson_edge_blog_style=="4"){
			if($hudson_edge_blog_masonry_type == "blog_masonry_standard"){
				$hudson_edge_blog_list = "blog_masonry";
				$hudson_edge_blog_list_class = "masonry_full_width";
			}
        }elseif($hudson_edge_blog_style=="9"){
			$hudson_edge_blog_list = "blog_standard_whole_post";
			$hudson_edge_blog_list_class = "blog_standard_type";
		}elseif($hudson_edge_blog_style=="14"){
			$hudson_edge_blog_list = "blog_masonry_gallery";
			$hudson_edge_blog_list_class = "blog_masonry_gallery";
		}elseif($hudson_edge_blog_style=="15"){
			$hudson_edge_blog_list = "blog_masonry_gallery";
			$hudson_edge_blog_list_class = "blog_masonry_gallery masonry_gallery_full_width";
		}else {
			$hudson_edge_blog_list = "blog_standard";
			$hudson_edge_blog_list_class = "blog_standard_type";
		}
	}

    $hudson_edge_pagination_masonry = "pagination";
    if(isset($hudson_edge_options['pagination_masonry'])){
       $hudson_edge_pagination_masonry = $hudson_edge_options['pagination_masonry'];
		if($hudson_edge_blog_list == "blog_masonry") {
			$hudson_edge_blog_list_class .= " masonry_" . $hudson_edge_pagination_masonry;
		}
    }
	
	$hudson_edge_pagination_masonry_gallery = "pagination";
    if(isset($hudson_edge_options['pagination_masonry_gallery'])){
       $hudson_edge_pagination_masonry_gallery = $hudson_edge_options['pagination_masonry_gallery'];
		if($hudson_edge_blog_list == "blog_masonry_gallery") {
			$hudson_edge_blog_list_class .= " masonry_" . $hudson_edge_pagination_masonry_gallery;
		}
    }
?>
<?php

	if(($hudson_edge_blog_list == "blog_masonry"  || $hudson_edge_blog_list == "blog_masonry_gallery") && $hudson_edge_filter == "yes") {
		get_template_part('templates/blog/masonry', 'filter');

	}

	$hudson_edge_blog_masonry_columns = 'three_columns';
	if (isset($hudson_edge_options['blog_masonry_columns']) && $hudson_edge_options['blog_masonry_columns'] !== '') {
		$hudson_edge_blog_masonry_columns = $hudson_edge_options['blog_masonry_columns'];
	}

	$hudson_edge_blog_masonry_full_width_columns = 'five_columns';
	if (isset($hudson_edge_options['blog_masonry_full_width_columns']) && $hudson_edge_options['blog_masonry_full_width_columns'] !== '') {
		$hudson_edge_blog_masonry_full_width_columns = $hudson_edge_options['blog_masonry_full_width_columns'];
	}
	
	$hudson_edge_blog_masonry_gallery_column = 'two_columns';
	if (isset($hudson_edge_options['blog_masonry_gallery_columns']) && $hudson_edge_options['blog_masonry_gallery_columns'] !== '') {
		$hudson_edge_blog_masonry_gallery_column = $hudson_edge_options['blog_masonry_gallery_columns'];
	}

	$hudson_edge_blog_masonry_gallery_full_width_columns = 'three_columns';
	if (isset($hudson_edge_options['blog_masonry_gallery_full_width_columns']) && $hudson_edge_options['blog_masonry_gallery_full_width_columns'] !== '') {
		$hudson_edge_blog_masonry_gallery_full_width_columns = $hudson_edge_options['blog_masonry_gallery_full_width_columns'];
	}
	
	if($hudson_edge_template_name == "blog-masonry.php" || $hudson_edge_blog_style == 3 ){
		$hudson_edge_blog_list_class .= " " .$hudson_edge_blog_masonry_columns;
	}
	
	if($hudson_edge_template_name == "blog-masonry-full-width.php" || $hudson_edge_blog_style == 4){
		$hudson_edge_blog_list_class .= " " .$hudson_edge_blog_masonry_full_width_columns;
	}

	if($hudson_edge_template_name == "blog-masonry-gallery.php" || $hudson_edge_blog_style == 14 ){
		$hudson_edge_blog_list_class .= " " .$hudson_edge_blog_masonry_gallery_column;
	}
	
	if($hudson_edge_template_name == "blog-masonry-gallery-full-width.php" || $hudson_edge_blog_style == 15){
		$hudson_edge_blog_list_class .= " " .$hudson_edge_blog_masonry_gallery_full_width_columns;
	}

	
	$hudson_edge_icon_left_html =  "<i class='pagination_arrow arrow_carrot-left'></i>";
	if (isset($hudson_edge_options['pagination_arrows_type']) && $hudson_edge_options['pagination_arrows_type'] != '') {
		$hudson_edge_icon_navigation_class = $hudson_edge_options['pagination_arrows_type'];
		$hudson_edge_direction_nav_classes = hudson_edge_horizontal_slider_icon_classes($hudson_edge_icon_navigation_class);
		$hudson_edge_icon_left_html = '<span class="pagination_arrow ' . $hudson_edge_direction_nav_classes['left_icon_class']. '"></span>';
	}
	
	$hudson_edge_icon_left_html .= '<span class="pagination_label">';
	if (isset($hudson_edge_options['blog_pagination_previous_label']) && $hudson_edge_options['blog_pagination_previous_label'] != '') {
		$hudson_edge_icon_left_html.= $hudson_edge_options['blog_pagination_previous_label'];
	}
	else{
		$hudson_edge_icon_left_html .= "Previous";
	}
	$hudson_edge_icon_left_html .= '</span>';


	$hudson_edge_icon_right_html = '<span class="pagination_label">';
	if (isset($hudson_edge_options['blog_pagination_next_label']) && $hudson_edge_options['blog_pagination_next_label'] != '') {
		$hudson_edge_icon_right_html .= $hudson_edge_options['blog_pagination_next_label'];
	}
	else {
		$hudson_edge_icon_right_html .= "Next";
	}
	$hudson_edge_icon_right_html .= '</span>';

	if (isset($hudson_edge_options['pagination_arrows_type']) && $hudson_edge_options['pagination_arrows_type'] != '') {
		$hudson_edge_icon_navigation_class = $hudson_edge_options['pagination_arrows_type'];
		$hudson_edge_direction_nav_classes = hudson_edge_horizontal_slider_icon_classes($hudson_edge_icon_navigation_class);
		$hudson_edge_icon_right_html .= '<span class="pagination_arrow ' . $hudson_edge_direction_nav_classes['right_icon_class']. '"></span>';
	}
	else{
		$hudson_edge_icon_right_html .=  "<i class='pagination_arrow arrow_carrot-right'></i>";
	}

	?>

	<div class="blog_holder <?php echo esc_attr($hudson_edge_blog_list_class); ?>">
		
	<?php if($hudson_edge_blog_list == "blog_masonry" || $hudson_edge_blog_list == "blog_masonry_gallery" ) { ?>
		<div class="blog_holder_grid_sizer"></div>
		<div class="blog_holder_grid_gutter"></div>
	<?php } ?>
	<?php if($hudson_edge_blog_query->have_posts()) : while ( $hudson_edge_blog_query->have_posts() ) : $hudson_edge_blog_query->the_post(); ?>
		<?php
			get_template_part('templates/blog/'.$hudson_edge_blog_list, 'loop');
		?>
	<?php endwhile; ?>
	<?php if($hudson_edge_blog_list != "blog_masonry" && $hudson_edge_blog_list != "blog_masonry_meta_info_featured_on_side" && $hudson_edge_blog_list != "blog_masonry_gallery") {
		if ($hudson_edge_options['blog_pagination_type'] == 'standard'){
				hudson_edge_pagination($hudson_edge_blog_query->max_num_pages, $hudson_edge_blog_page_range, $hudson_edge_paged);
			}
		elseif ($hudson_edge_options['blog_pagination_type'] == 'prev_and_next'){?>
			<div class="pagination_prev_and_next_only">
				<ul>
					<li class='prev'><?php echo wp_kses_post(get_previous_posts_link($hudson_edge_icon_left_html)); ?></li>
					<li class='next'><?php echo wp_kses_post(get_next_posts_link($hudson_edge_icon_right_html, $hudson_edge_blog_query->max_num_pages)); ?></li>
				</ul>
			</div>
		<?php } ?>
	<?php } ?>
	<?php else: //If no posts are present ?>
	<div class="entry">
			<p><?php esc_html_e('No posts were found.', 'hudson'); ?></p>
	</div>
	<?php endif; ?>
</div>
<?php if($hudson_edge_blog_list == "blog_masonry") {
    if($hudson_edge_pagination_masonry == "load_more") {
		if ($hudson_edge_blog_query->max_num_pages > 1) { ?>
			<div class="blog_load_more_button_holder">
				<div class="blog_load_more_button"><span data-rel="<?php echo esc_attr($hudson_edge_blog_query->max_num_pages); ?>"><?php echo wp_kses_post(get_next_posts_link(esc_html__('Show more', 'hudson'), $hudson_edge_blog_query->max_num_pages)); ?></span></div>
			</div>
		<?php } ?>
	 <?php } elseif($hudson_edge_pagination_masonry == "infinite_scroll") { ?>
		<div class="blog_infinite_scroll_button"><span data-rel="<?php echo esc_attr($hudson_edge_blog_query->max_num_pages); ?>"><?php echo wp_kses_post(get_next_posts_link(esc_html__('Show more', 'hudson'), $hudson_edge_blog_query->max_num_pages)); ?></span></div>
    <?php }else { ?>
        <?php if($hudson_edge_options['blog_pagination_type'] == 'standard' && $hudson_edge_options['pagination'] != "0") {
				hudson_edge_pagination($hudson_edge_blog_query->max_num_pages, $hudson_edge_blog_page_range, $hudson_edge_paged);
            }
        	elseif ($hudson_edge_options['blog_pagination_type'] == 'prev_and_next'){ ?>
				<div class="pagination_prev_and_next_only">
					<ul>
						<li class='prev'><?php echo wp_kses_post(get_previous_posts_link($hudson_edge_icon_left_html)); ?></li>
						<li class='next'><?php echo wp_kses_post(get_next_posts_link($hudson_edge_icon_right_html, $hudson_edge_blog_query->max_num_pages)); ?></li>
					</ul>
				</div>
		<?php } ?>
    <?php } ?>
<?php } ?>
<?php if($hudson_edge_blog_list == "blog_masonry_gallery") {
    if($hudson_edge_pagination_masonry_gallery == "load_more") {
		if ($hudson_edge_blog_query->max_num_pages > 1) { ?>
			<div class="blog_load_more_button_holder">
				<div class="blog_load_more_button"><span data-rel="<?php echo esc_attr($hudson_edge_blog_query->max_num_pages); ?>"><?php echo wp_kses_post(get_next_posts_link(esc_html__('Show more', 'hudson'),$hudson_edge_blog_query->max_num_pages)); ?></span></div>
			</div>
		<?php } ?>
	 <?php } elseif($hudson_edge_pagination_masonry_gallery == "infinite_scroll") { ?>
		<div class="blog_infinite_scroll_button"><span data-rel="<?php echo esc_attr($hudson_edge_blog_query->max_num_pages); ?>"><?php echo wp_kses_post(get_next_posts_link(esc_html__('Show more', 'hudson'),$hudson_edge_blog_query->max_num_pages)); ?></span></div>
    <?php }else { ?>
        <?php if($hudson_edge_options['blog_pagination_type'] == 'standard' && $hudson_edge_options['pagination'] != "0") {
				hudson_edge_pagination($hudson_edge_blog_query->max_num_pages, $hudson_edge_blog_page_range, $hudson_edge_paged);
            }
        	elseif ($hudson_edge_options['blog_pagination_type'] == 'prev_and_next'){ ?>
				<div class="pagination_prev_and_next_only">
					<ul>
						<li class='prev'><?php echo wp_kses_post(get_previous_posts_link($hudson_edge_icon_left_html)); ?></li>
						<li class='next'><?php echo wp_kses_post(get_next_posts_link($hudson_edge_icon_right_html, $hudson_edge_blog_query->max_num_pages)); ?></li>
					</ul>
				</div>
		<?php } ?>
    <?php } ?>
<?php } ?>
<?php wp_reset_postdata(); ?>
